/*! \file tlk_cert_api_odrm.h 
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_api_odrm.h 
*
* Project, Target, subsystem:   Toolkit, Certificate Handling
* 
* Created:                      29.01.2008
*
* Modified:                     29.01.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_API_ODRM_H_
#define _TLK_CERT_API_ODRM_H_

#include "tlk_cert_types.h"
#ifdef __cplusplus
extern "C"
{
#endif

/************************************************************************/
/* Note:  The flag CERT_API_ODRM is temporary till we will implement the*/
/*        TLK_CERT_ODRM_KmacAndKmekEncryptUnderKri function             */
/************************************************************************/
#ifdef CERT_API_ODRM
#include "tlk_odrm_errors.h"
#include "tlk_odrm_types.h"
#endif

#ifdef CERT_API_ODRM
/**
* @brief    The purpose of this function is to derive KMAC and KMEC under RI public key which is a part of the given 
*           certificate. This function will perform all necessary field verification of the CVPO, extract RSA public 
*           key from the CVPO and call TLK_ODRM_KmacAndKmekEncryptUnderKri() function.
*           
* @param keyesRing_ptr                  [in]   - Parameters for Kmac ad KMEK keys ring access in KMNG environment 
* @param certificate_ptr                [in]   - Pointer to the given certificate 
* @param kMac_ptr                       [in]   - A Kmac id in the key ring
* @param kMek_ptr                       [in]   - A Kmek id in the key ring
* @param c_ptr                          [out]  - A pointer to concatenated string of Z (random value) and wrapped concatenations
*                                                of Kmac and Kmek before base64 encoding.
* @param workspace_ptr                  [in]   - Pointer to the workspace buffer (must be allocated by user) 
* @param workspaceSizeInBytes           [in]   - Length of the workspace buffer

* @return TLK_CERT_RC_OK	                 - The operation completed successfully.
* @return TLK_CERT_RC_FAIL                   - The operation failed.
*/
DxError_t TLK_CERT_ODRM_KmacAndKmekEncryptUnderKri(         const   TLK_ODRM_KMNGKeyRing_t      *keyesRing_ptr,
                                                            const   TLK_CERT_Buffer_t           *certificate_ptr,
                                                            const   TLK_ODRM_KMNGKey_t          *kMac_ptr,
                                                            const   TLK_ODRM_KMNGKey_t          *kMek_ptr,
                                                                    TLK_ODRM_Buffer_t           *c_ptr,
                                                            const   DxByte_t                    *workspace_ptr,
                                                            const   DxUint32_t                   workspaceSizeInBytes);
#endif
/**
* @brief    The purpose of this function is to to retrieving all certificate parameters (field values).
*           The certificate identifier will be calculated from the hash of the complete DER-encoded subjectPublicKeyInfo component
* @param certificate_ptr                [in]   - Pointer to the certificate to be processed 
* @param certificateId                  [out]  - Pointer to the required certificate parameters list
* @param certificateParamList_ptr       [out]  - Pointer to the calculated certificate identifier

* @return TLK_CERT_RC_OK	                 - The operation completed successfully.
* @return TLK_CERT_RC_FAIL                   - The operation failed.
*/
DxError_t TLK_CERT_ODRM_V2_1_CertifcateIDComputeParamGet(   const   TLK_CERT_Buffer_t           *certificate_ptr,
                                                                    DxSha1Result_t               certificateId,
                                                                    TLK_CERT_CertParameters_t   *certificateParamList_ptr);

#ifdef __cplusplus
}
#endif /*extern "C"*/
#endif
